'==========================================================================
'
'	NAME: LocalAcct.vbs
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================


Public Function CreateLocalAccount(strName,strPassword, objWINNT)
'==========================================================================
'	NAME: CreateLocalAccount
'	INPUT:	strName - SAMAccount anme (20 char. limit)
'			strPassword - password for the user account
'			objWINNT - Instance of computer object
'	OUTPUT: instance of local user object
'	
'	COMMENT: 	Creates a local user account
'==========================================================================
	Dim objCls
	'We need to clean up the user name
	strName = CleanName(strName)
	'SAMAccountName cannot be more than 20 characters
	'so truncate it if it is more
	If Len(strName) > 20 Then
		strName = Left(strName,20)
	End If
	'Check to see if the user exists
	If objectExists(strName,"user",objWINNT) Then
		'Create a unique object
		Do Until Not objectExists(strName,"user",objWINNT)
			strName = CreateUniqueName(strName)
		Loop
	End If
		
	'Create the user
	Set objCls = CreateLocalObject(strName,"user",objWINNT,strPassword)
	'Pass User container back
	Set CreateLocalAccount = objCls

end Function
Public Function CreateLocalGroup(strName,objWINNT)
'=============================================================================
' NAME:		CreateLocalGroup
' INPUTS:	strName - Name of the group to create
'			objWINNT - Computer object
' OUTPUT:	Container object for Group
' COMMENTS: Creates an instance of the group container
'=============================================================================
	Dim objGroup
	'We need to clean up the user name
	strName = CleanName(strName)
		'SAMAccountName cannot be more than 20 characters
	'so truncate it if it is more
	If Len(strName) > 20 Then
		strName = Left(strName,20)
	End If
	'Check to see if the group exists
	If objectExists(strName,"group",objWINNT) Then
		'Create a unique object
		Do Until Not objectExists(strName,"group",objWINNT)
			strName = CreateUniqueName(strName)
		Loop
	End If
	'Create the group
	Set objGroup = CreateLocalObject(strName,"group",objWINNT,"")
	'Pass the object back
	Set CreateLocalGroup = objGroup
	
End Function

Function CreateUniqueName(strName)
'==========================================================================
'	NAME: CreateUniqueName
'	INPUT:	strName - SAMAccount anme (20 char. limit)
'			
'	OUTPUT: Unique Account Name
'	
'	COMMENT: 	Creates a valid, unique SAMAccountName
'==========================================================================
	Dim nCounter
	Dim strTemp
	'Initialize Counter
	nCounter = 1
	'Create name
	strTemp = strName & nCounter
	'trncate if longer than 20 chars (SAMAccountNAme max).
	If Len(strTemp) > 20 Then
		strTemp = Left(strName,Len(strName)-(len(strTemp)-20)) & nCounter
	End If
	'Pass it back
	CreateUniqueName = strTemp

End Function


Public Function CleanName(strName)
'==========================================================================
'	NAME: CleanString
'	INPUT:	strString - The string to be cleaned
'	OUTPUT: Cleaned up string
'	
'	COMMENT: 	Creates a string valid for creatign a SamAccountName
'==========================================================================
	Dim strCleaned
	strCleaned = Split(strName,".")(0)
	strCleaned = Replace(strCleaned,"@","_")
	CleanName = strCleaned

End Function

	
Function CreateLocalObject(strName,strClass,objWINNT,strPass)
'==========================================================================
'	NAME: CreateLocalObject
'	INPUT:	strName - SAMAccount name of object (20 Char. limit).
'			strClass - 'user' or 'group' are the valid entries
'			objWINNT - Instance of computer object
'			strPass - Password (used only with 'user' class, else pass empty string)
'	OUTPUT: Instance of object
'	
'	COMMENT: 	Creates a local account object (user or group) on the machine.
'				If the object exists, it opens it and passes it back.
'==========================================================================
	Dim objClass
	'Create the object
	Set objClass = objWINNT.create(strClass,strName)
	'If it is a user class, set the password
	If strClass = "user" Then
		objClass.SetPassword strPass
	End If
	'Save the info
	objClass.setinfo
	Set CreateLocalObject = objClass


End Function


Public Function getConnection(strComputer)
'==========================================================================
'	NAME: getConnection
'	INPUT:	strComputer - Name of the lcoal computer
'	OUTPUT: instance of computer object
'	
'	COMMENT: 	Creates an instance of the computer object
'==========================================================================
	Dim objWINNT
	Set objWINNT = GetObject("WinNT://" & strComputer)
	Set getConnection = objWINNT


End Function

Function objectExists(strName,strClass,objWINNT)
'==========================================================================
'	NAME: objectExists
'	INPUT:	strName - SAMAccount name of object (20 Char. limit).
'			strClass - 'user' or 'group' are the valid entries
'			objWINNT - Instance of computer object
'	OUTPUT: Boolean (True - it exists; Flase - it doesn;t).
'	
'	COMMENT: 	Checks for existance of object
'==========================================================================
	Dim bExists
	Dim objClass
	objWINNT.Filter = Array(strClass)
	
	For Each objClass In objWINNT
		If strName = objClass.Name Then
			bExists = True
			Exit For
		Else
			bExists = False
		End if
	Next
	
	objectExists = bExists
	

End Function

Function SetPasswordProperties(oLocal,bChange)
'==============================================================================
'	Name: SetPasswordProperties
'	IN:	oLocal - Local user object
'	OUT:	Return value
'	COmment: Sets the Password never expires or the user can't change password
'			 flag for a local user object
'==============================================================================
	Const ADS_UF_DONT_EXPIRE_PASSWD = &h10000
	Const ADS_UF_PASSWD_CANT_CHANGE = &h40
	
	Dim oUserFlags
	Dim oPwdFlag
	oUserFlags = oLocal.Get("UserFlags")
	oPwdFlag = oUserFlags Or ADS_UF_DONT_EXPIRE_PASSWD
	If bChange = True Then
		oPwdFlag = oPwdFlag Or ADS_UF_PASSWD_CANT_CHANGE
	End If
	oLocal.Put "userFlags",oPwdFlag
	oLocal.SetInfo
	SetPasswordProperties = "Password properties set for user " & oLocal.Name

End function